; ================================================================ ;
;  Common data                                                     ;
; ================================================================ ;

; ---------------------------------------------------------------- ;
;  Macros                                                          ;
; ---------------------------------------------------------------- ;

            INCLUDE     "tracker.mac"

; ---------------------------------------------------------------- ;
;  Pitch effects                                                   ;
; ---------------------------------------------------------------- ;

; ---------------------------------------------------------------- ;
;  Envelopes                                                       ;
; ---------------------------------------------------------------- ;

; ---------------------------------------------------------------- ;
;  Drums                                                           ;
; ---------------------------------------------------------------- ;

; ================================================================ ;
;  Song #00 - untitled                                             ;
; ================================================================ ;

song00      PROC

; ---------------------------------------------------------------- ;
;  Header                                                          ;
; ---------------------------------------------------------------- ;

            ; speed / pointers
            DECLE       7, @@patterns, @@instr

            ; order of patterns
            DECLE       00, 01, 00, 01, 02, 03, 00, 01
            DECLE       00, 01, 02, 03
            DECLE       -1 AND $FFFF

; ---------------------------------------------------------------- ;
;  Detail of patterns                                              ;
; ---------------------------------------------------------------- ;

@@patterns: DECLE       32, @@p000, @@p001, @@p002    ; 00
            DECLE       32, @@p000, @@p003, @@p002    ; 01
            DECLE       32, @@p000, @@p004, @@p002    ; 02
            DECLE       32, @@p000, @@p005, @@p002    ; 03

; ---------------------------------------------------------------- ;
;  Patterns                                                        ;
; ---------------------------------------------------------------- ;

            ; pattern #00 / channel A
@@p000:     Notes("A-2 0F1", "A-1 0F1", "A-2 0F1", "A-1 0F0")
            Notes("A-2 0F1", "A-2 0F1", "A-1 0F0", "A-2 0F0")
            Notes("A-1 0F0", "A-2 0F0", "B-2 0F0", "C-3 0F1")
            Notes("C-2 0F1", "C-3 0F1", "C-2 0F0", "C-3 0F1")
            Notes("C-3 0F1", "C-2 0F0", "C-3 0F0", "C-2 0F0")
            Notes("C-3 0F0", "B-2 0F0", "", "")

            ; pattern #00 / channel B
@@p001:     Notes("E-4 0F3", "A-4 0F3", "C-5 0F3", "D-5 0F3")
            Notes("E-5 0F3", "E-5 0F1", "D-5 0F1", "C-5 0F3")
            Notes("D-5 0F3", "", "", "")

            ; pattern #00 / channel C
@@p002:     Notes("DRM 0F1", "DRM 0F1", "DRM 0F1", "DRM 0F1")
            Notes("DRM 0F1", "DRM 0F1", "DRM 0F1", "DRM 0F1")
            Notes("DRM 0F1", "DRM 0F1", "DRM 0F1", "DRM 0F1")
            Notes("DRM 0F1", "DRM 0F1", "DRM 0F1", "DRM 0F0")
            Notes("DRM 0F0", "", "", "")

            ; pattern #01 / channel B
@@p003:     Notes("E-4 0F3", "A-4 0F3", "C-5 0F3", "B-4 0F3")
            Notes("C-5 0F2", "C-5 0F0", "A-4 0F2", "A-4 0F0")
            Notes("G-4 0F2", "G-4 0F0", "A-4 0F1", "G-4 0F1")

            ; pattern #02 / channel B
@@p004:     Notes("E-4 0FD", "C-5 0F0", "B-4 0F0", "A-4 0FD")
            Notes("G-4 0F0", "A-4 0F0", "", "")

            ; pattern #03 / channel B
@@p005:     Notes("E-4 0FD", "A-4 0F0", "C-5 0F0", "E-5 0F7")
            Notes("C-2 0F0", "C-2 0F0", "C-2 0F0", "C-2 0F0")
            Notes("C-2 0F0", "C-2 0F0", "C-2 0F0", "C-2 0F0")

            ENDP
