;;==========================================================================;;
;; Joe Zbiciak's Tag-Along Todd 3, with Voice!                              ;;
;;                                                                          ;;
;; Updated by David Harley                                                  ;;
;;==========================================================================;;

;dddd
;     MVI DIRECTION2, R0
;     MVII    #4, R1                           ; Amount of numbers to print
;     MVII    #1, R3                           ; Color to print the message
;     MVII    #$0202, R4                           ; Where to print the message; Over right the year
;     JSR     R5, $18C5                            ; Print number in R0


            ROMW    16              ; Use 16-bit ROM

;------------------------------------------------------------------------------
; Include system information
;------------------------------------------------------------------------------
            INCLUDE "gimini.asm"    ; System offsets, etc.
            INCLUDE "resrom2.asm"   ; RESROM indices

;------------------------------------------------------------------------------
; Global constants and configuration.
;------------------------------------------------------------------------------
TSKQM       EQU     $7              ; Task queue is 8 entries large
MAXTSK      EQU     2               ; Only one task

CAN         EQU     288 * 8 + C_YEL ; The can you're trying to collect
ARROW       EQU     289 * 8 + C_YEL ; The arrow for the menu
FENCE       EQU     292 * 8 + C_DGR ; The fence for the yard
TITLELOGO   EQU     165 * 8

BG1         EQU     231 * 8 + C_GRN ;dddd ; from GROM
BG2         EQU     234 * 8 + C_GRN ;dddd ; from GROM
BG3         EQU     221 * 8 + C_GRN ;dddd ; from GROM

PH_TITLE    EQU     43              ; Intellivoice phrases
PH_LETSPLAY EQU     75
PH_GETSET   EQU     76
PH_START    EQU     77
PH_READYGO  EQU     78
PH_GAMEOVER EQU     79
PH_OK       EQU     80
PH_GOOD     EQU     81
PH_GREAT    EQU     82
PH_SUPER    EQU     83
PH_AWESOME  EQU     84
PH_EXPERT   EQU     85
PH_WOW      EQU     86
PH_FINAL    EQU     87
PH_SCORE    EQU     88
PH_BASEBALL EQU     89
PH_BASKET   EQU     90
PH_HOCKEY   EQU     91
PH_SOCCER   EQU     92
PH_TENNIS   EQU     93

G_FADE      EQU         $0112                   ; global volume fade



;------------------------------------------------------------------------------
; Allocate 8-bit variables in Scratch RAM
;------------------------------------------------------------------------------
SCRATCH     ORG     $100, $100, "-RWBN"

ISRVEC      RMB     2               ; Always at $100 / $101

SPRITE      RMB     1               ; running man dddd
SPRITE1     RMB     1               ; running man dddd
DIRECTION   RMB     1               ; keypad direction
DIRECTION2  RMB     1               ; keypad direction

            ; Task-oriented 8-bit variables
TSKQHD      RMB     1               ; Task queue head
TSKQTL      RMB     1               ; Task queue tail
TSKDQ       RMB     2*(TSKQM+1)     ; Task data queue
TSKACT      RMB     1               ; Number of active tasks

            ; Hand-controller 8-bit variables
SH_TMP      RMB     1               ; Temp storage.
SH_LR0      RMB     3               ;\
SH_FL0      EQU     SH_LR0 + 1      ; |-- Three bytes for left controller
SH_LV0      EQU     SH_LR0 + 2      ;/
SH_LR1      RMB     3               ;\
SH_FL1      EQU     SH_LR1 + 1      ; |-- Three bytes for right controller
SH_LV1      EQU     SH_LR1 + 2      ;/

            ; DEC16 temp storage
DEC_0       RMB     2
DEC_1       EQU     DEC_0 + 1

            ; Misc other stuff
GAME_LEN    RMB     1               ; Length of game in seconds
TIMELEFT    RMB     1               ; Time left in game.
SCORE       RMB     1               ; Score
NUM_CANS    RMB     1               ; Number of cans still onscreen.
NUM_BG      RMB     1               ; Number of background images of grass
M_ROW       RMB     1               ; menu row for arrow

            ; Intellivoice-specific variables
IV.QH       RMB     1               ; Intellivoice: phrase queue head
IV.QT       RMB     1               ; Intellivoice: phrase queue tail
IV.Q        RMB     8               ; Intellivoice: phrase queue
IV.FLEN     RMB     1               ; Intellivoice: FIFO'd data length

Color0      RMB     1               ; border color
Color1      RMB     1               ; background
Color2      RMB     1               ; border color
Color3      RMB     1               ; border color
Color4      RMB     1               ; border color

LEVEL       RMB     1               ; Level the player is on
SAY_NUM     RMB     1
CAUGHT      RMB     1

_SCRATCH    EQU     $               ; end of scratch area



;------------------------------------------------------------------------------
; Allocate 16-bit variables in System RAM
;------------------------------------------------------------------------------


SYSTEM      ORG     $2F0, $2F0, "-RWBN"
STACK       RMB     32              ; Reserve 32 words for the stack

            ; Task-oriented 16-bit variables
TSKQ        RMB     (TSKQM + 1)     ; Task queue
TSKTBL      RMB     (MAXTSK * 4)    ; Timer task table

            ; Hand-controller 16-bit variables
SHDISP      RMB     1               ; ScanHand dispatch

            ; STIC shadow
STICSH      RMB     24              ; Room for X, Y, and A regs only.

            ; Misc other stuff
PLYR        PROC
@@TXV       RMB     1               ; Target X velocity
@@XV        RMB     1               ; X velocity
@@XP        RMB     1               ; X position
@@TYV       RMB     1               ; Target Y velocity
@@YV        RMB     1               ; Y velocity
@@YP        RMB     1               ; Y position
            ENDP

TODD        PROC                    ; TODD's STATS
@@TXV       RMB     1               ; Target X velocity
@@XV        RMB     1               ; X velocity
@@XP        RMB     1               ; X position
@@TYV       RMB     1               ; Target Y velocity
@@YV        RMB     1               ; Y velocity
@@YP        RMB     1               ; Y position
            ENDP

RNDHI       RMB     1
RNDLO       RMB     1

MOB_BUSY    RMB     1               ; If non-zero, disables MOB updates

SKILL       RMB     1               ; Skill level [1 - 9]
DURATION    RMB     1               ; Game duration [1 - 9]
INIT_VEL    RMB     1               ; Initial velocity
TODD_VEL    RMB     1               ; Todd's velocity (game difficulty)

            ; Intellivoice-specific variables
IV.FPTR     RMB     1               ; Intellivocie: FIFO'd data pointer
IV.PPTR     RMB     1               ; Intellivocie: Phrase pointer

TBORDER     RMB     1 ;DDDD

_SYSTEM     EQU     $               ; end of system area


;------------------------------------------------------------------------------
; EXEC-friendly ROM header.
;------------------------------------------------------------------------------
            ORG     $5000           ; Use default memory map
ROMHDR:     BIDECLE ZERO            ; MOB picture base   (points to NULL list)
            BIDECLE ZERO            ; Process table      (points to NULL list)
            BIDECLE MAIN            ; Program start address
            BIDECLE ZERO            ; Bkgnd picture base (points to NULL list)
            BIDECLE ONES            ; GRAM pictures      (points to NULL list)
            BIDECLE TITLE           ; Cartridge title/date
            DECLE   $03C0           ; No ECS title, run code after title,
                                    ; ... no clicks
ZERO:       DECLE   $0000           ; Screen border control
            DECLE   $0000           ; 0 = color stack, 1 = f/b mode
ONES:       DECLE   C_BLU, C_BLU    ; Initial color stack 0 and 1: Blue
            DECLE   C_BLU, C_BLU    ; Initial color stack 2 and 3: Blue
            DECLE   C_BLU           ; Initial border color: Blue
;------------------------------------------------------------------------------


;; ======================================================================== ;;
;;  TITLE  -- Display our modified title screen & copyright date.           ;;
;; ======================================================================== ;;

TITLE:
            STRING  104, "Tag-Along Todd 3", 0

;; ======================================================================== ;;
;;  MAIN:  Here's our main program code.                                    ;;
;; ======================================================================== ;;
MAIN:       PROC
            DIS

            CALL        init_psg                ; initialize PSG

            MVII    #STACK, R6      ; Set up our stack

            MVII    #$25D,  R1      ;\
            MVII    #$102,  R4      ; |-- Clear all of memory
            CALL    FILLZERO        ;/

            MVO     PC,     MOB_BUSY; Disable MOBs for now.

            CALL    IV_INIT         ; Initialize Intellivoice (if present)

            MVII    #INITISR, R0    ;\    Do GRAM initialization in ISR.
            MVO     R0,     ISRVEC  ; |__ INITISR will the point to the
            SWAP    R0              ; |   regular ISR when it's done.
            MVO     R0,     ISRVEC+1;/

            MVO     PC,     RNDHI

            EIS

            MVII    #C_PUR, R0
            MVO     R0, Color0      ; Set the color for the title screen
            MVO     R0, Color4      ; Set the border color

            CALL    TSCREEN         ; Show title screen
            CALL    RUNQ

@@gameloop:

            MVII    #C_CYN, R0
            MVO     R0, Color0      ; Set the color for the menu screen
            MVO     R0, Color4      ; Set the border color

            CALL    MENU            ; Get information
            CALL    RUNQ

            MVII    #C_YGR, R0
            MVO     R0, Color0      ; Set the color for the title screen
            MVII    #1, R0
            MVO     R0, Color4      ; Set the border color

            CALL    GAME            ; Run the game

            CALL    RUNQ

            CALL    GAMEOVER        ; Game over!
            CALL    RUNQ

            B       @@gameloop
            ENDP

;; ======================================================================== ;;
;;  HEXIT   Dispatch table that just calls SCHEDEXIT for everything.        ;;
;; ======================================================================== ;;

HEXIT       PROC
            DECLE   EXITPRESS
            DECLE   EXITPRESS
            DECLE   EXITPRESS
            ENDP

;; ======================================================================== ;;
;;  EXITPRESS -- Schedule an exit only when a key is pressed, not released. ;;
;; ======================================================================== ;;

EXITPRESS   PROC
            SWAP    R2,     2       ; test bit 7 of R2
            BPL     SCHEDEXIT       ; if clear, schedule the exit
            JR      R5              ; if set, ignore the keypress.
            ENDP

;; ======================================================================== ;;
;;  TSCREEN -- Title screen.                                                ;;
;; ======================================================================== ;;

TSCREEN     PROC
            PSHR    R5

            CALL    CLRSCR

            CALL    PRINT.FLS
            DECLE   C_BLK, $200 + 1*20
                    ;01234567890123456789
            STRING  "  Joe Z. & David H  "
            STRING  "                    "
            STRING  "      presents      ",0

            CALL    PRINT.FLS
            DECLE   C_YEL, $200 + 6*20
                    ;01234567890123456789
            STRING  "   Tag-Along Todd   ",0

            CALL    PRINT.FLS
            DECLE   C_BLK, $200 + 10*20
                    ;01234567890123456789
            STRING  "   Ver. 3.13 Beta   ", 0

            CALL    IV_PLAYW
            DECLE   PH_TITLE

            CLRR    R0
            MVO     R0,     TSKACT      ; No active tasks

            MVII    #HEXIT, R0
            MVO     R0,     SHDISP      ; Any controller input -> Exit screen

            MVO     PC,     MOB_BUSY    ; Disable MOB updates

            MVII    #STICSH, R4         ;\
            MVII    #24,    R1          ; |-- Clear away the MOBs
            CALL    FILLZERO            ;/

; Set the default values for skill and duration. This is increased as game is played.

            MVII    #3,     R0
            MVO     R0,     SKILL

            MVII    #4,     R0
            MVO     R0,     DURATION

            PULR    PC
            ENDP

;; ======================================================================== ;;
;;  M_HAND  Dispatch table for menu.                                        ;;
;; ======================================================================== ;;

M_HAND      PROC
            DECLE   M_DIGIT     ; Keypad dispatch
            DECLE   0           ; Action-button dispatch -> disabled
            DECLE   M_DISC      ; DISC dispatch
            ENDP

;; ======================================================================== ;;
;;  MENU    Display a menu onscreen.                                        ;;
;; ======================================================================== ;;

MENU        PROC
            PSHR    R5

            CALL    CLRSCR

            ;; ------------------------------------------------------------ ;;
            ;;  Set the defaults.                                           ;;
            ;; ------------------------------------------------------------ ;;

            MVI     SKILL,  R1          ; Update skill level
            SLL     R1,     2
            SLL     R1,     2
            SLL     R1,     1
            MVO     R1,     INIT_VEL    ; Todd's velocity = 0x20 * skill

            MVI     DURATION,  R0
            MOVR    R0,     R1
            SLL     R1,     2
            ADDR    R0,     R1
            SLL     R1,     1
            MVO     R1,     GAME_LEN    ; Game length = 10 seconds * digit.

            MVII    #5,     R0
            MVO     R0,     NUM_BG

            MVII    #$FF, R0            ; Set the flag to stop the animation
            MVO     R0, DIRECTION

            MVII    #9*20,  R0
            MVO     R0,     M_ROW

            MVII    #0,     R0
            MVO     R0,     LEVEL

            MVII    #2304,  R0
            MVO     R0,     TBORDER

            MVII    #0,     R0
            MVO     R0,     CAUGHT

            ;; ------------------------------------------------------------ ;;
            ;;  Display the menu screen.                                    ;;
            ;; ------------------------------------------------------------ ;;

            CALL    PRINT.FLS
            DECLE   C_BLK,  $200
                    ;01234567890123456789
            STRING  "      OPTIONS       ", 0

            CALL    PRINT.FLS
            DECLE   C_DGR,  $200 + 2*20 + 1
                    ;01234567890123456789
            STRING  "Skill level [1-9]:", 0

            CALL    PRINT.FLS
            DECLE   C_DGR,  $200 + 5*20 + 1
                    ;01234567890123456789
            STRING  "Duration    [1-9]:", 0

            CALL    PRINT.FLS
            DECLE   C_DGR,  $200 + 8*20 + 1
                    ;01234567890123456789
            STRING  "Start the Game    ", 0

            MVI     SKILL,  R0
            MVII    #1, R1                               ; Amount of numbers to print
            MVII    #C_BLU, R3                           ; Color to print the message
            MVII    #$0245, R4                           ; Where to print the message; Over right the year
            JSR     R5, $18C5                            ; Print number in R0

            MVI     DURATION,  R0
            MVII    #1, R1                               ; Amount of numbers to print
            MVII    #C_BLU, R3                           ; Color to print the message
            MVII    #$0281, R4                           ; Where to print the message; Over right the year
            JSR     R5, $18C5                            ; Print number in R0

            CALL    PRINT.FLS
            DECLE   C_BLU,  $200 + 9*20 + 8
            STRING  "Go!", 0

            ;; ------------------------------------------------------------ ;;
            ;;  Set the dispatch and menu animate task.                     ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #M_HAND,R0
            MVO     R0,     SHDISP

            CALL    STARTTASK           ;\
            DECLE   0                   ; |__ Blink the little arrow
            DECLE   M_BLINK             ; |
            DECLE   30,     30          ;/

            MVII    #1,     R0
            MVO     R0,     TSKACT
            PULR    PC
            ENDP

;; ======================================================================== ;;
;;  M_DIGIT -- Enter a digit on the current menu row.                       ;;
;;             Pressing enter moves to next row, or if at last, starts game ;;
;; ======================================================================== ;;

M_DIGIT     PROC
            ANDI    #$FF,   R2          ; ignore controller #.
            CMPI    #$80,   R2
            BLT     @@press             ; ignore release events.
@@leave:    JR      R5

@@press:    TSTR    R2
            BEQ     @@leave             ; ignore 'zero'
            CMPI    #10,    R2
            BEQ     @@leave             ; ignore 'clear'
            BLT     @@digit

            ;; ------------------------------------------------------------ ;;
            ;;  Handle the [Enter] key:  Move to next row in menu, or if    ;;
            ;;  on last row of menu, start the game.                        ;;
            ;; ------------------------------------------------------------ ;;

@@enter:    MVI     M_ROW,  R4
            ADDI    #$200 + 11, R4
            CLRR    R0
            MVO@    R0,     R4          ; Clear arrow from current row

            MVI     M_ROW,  R1
            ADDI    #3*20,  R1          ; move to next row
            CMPI    #9*20,  R1          ; were we on last row?
            BGT     SCHEDEXIT           ; Enter on last row starts game.

            MVO     R1,     M_ROW
            ADDI    #$200 + 11, R1
            MVII    #ARROW, R0
            MVO@    R0,     R1          ; Put arrow on current row
            JR      R5

            ;; ------------------------------------------------------------ ;;
            ;;  Handle digits [1] through [9].                              ;;
            ;; ------------------------------------------------------------ ;;

@@digit:    MVI     M_ROW,  R4
            CMPI    #6*20,  R4
            BGT     @@leave             ; Ignore digits when in last row
            BEQ     @@update_duration

            ;; ------------------------------------------------------------ ;;
            ;;  If we are on the top row, the input updates skill level.    ;;
            ;; ------------------------------------------------------------ ;;

            MVO     R2,     SKILL
            MOVR    R2,     R1          ; Update skill level
            SLL     R1,     2
            SLL     R1,     2
            SLL     R1,     1
            MVO     R1,     INIT_VEL    ; Todd's velocity = 0x20 * skill
            B       @@disp

            ;; ------------------------------------------------------------ ;;
            ;;  If we are on the middle row, the input updates the game     ;;
            ;;  duration.                                                   ;;
            ;; ------------------------------------------------------------ ;;

@@update_duration:
            MVO     R2,     DURATION
            MOVR    R2,     R1
            SLL     R1,     2
            ADDR    R2,     R1
            SLL     R1,     1
            MVO     R1,     GAME_LEN    ; Game length = 10 seconds * digit.

            ;; ------------------------------------------------------------ ;;
            ;;  Either way, if we're on the upper two rows, show the digit. ;;
            ;; ------------------------------------------------------------ ;;

@@disp:     ADDI    #$200+9,R4          ; offset to digit position in row.
            MOVR    R2,     R1
            SLL     R1,     2           ; move digit to card field in word
            SLL     R1,     1
            ADDI    #$80 + C_BLU, R1    ; add offset for '0', make digit blue
            MVO@    R1,     R4          ; show it.

            JR      R5
            ENDP

;; ======================================================================== ;;
;;  M_DISC  -- Move the selection arrow between menu rows.                  ;;
;; ======================================================================== ;;

M_DISC      PROC
            ANDI    #$FF,   R2          ; ignore controller #.
            CMPI    #$80,   R2
            BLT     @@press             ; ignore release events.
@@leave:    JR      R5
@@press:
            MVI     M_ROW,  R0          ; Get menu row
            MOVR    R0,     R1          ; save old position

            CMPI    #2,     R2
            BLT     @@leave             ; Ignore 'east' (directions 0, 1)
            CMPI    #13,    R2
            BGT     @@leave             ; Ignore 'east' (directions 14, 15)
            CMPI    #5,     R2
            BLE     @@move_up           ; Directions 2 - 5:  Move up
            CMPI    #10,    R2
            BLT     @@leave             ; Ignore 'west' (directions 6 - 9)

@@move_dn:  ADDI    #3*20,  R0          ; Move down to next item
            CMPI    #9*20,  R0          ; Is it past the end?
            BGT     @@leave             ; Yes:  Ignore the input
            MVO     R0,     M_ROW       ; No:   Save the update

            ADDI    #$200 + 11, R1      ;\    Move to old arrow's position
            CLRR    R0                  ; |-- and clear the old arrow
            MVO@    R0,     R1          ;/

            ADDI    #3*20,  R1          ;\    Move to new arrow's position
            MVII    #ARROW, R0          ; |-- and draw the new arrow.
            MVO@    R0,     R1          ;/
            JR      R5                  ; return.

@@move_up   SUBI    #3*20,  R0          ; Move up to prev item
            CMPI    #3*20,  R0          ; Is it past the top
            BLT     @@leave             ; Yes:  Ignore the input
            MVO     R0,     M_ROW       ; No:   Save the update

            ADDI    #$200 + 11, R1      ;\    Move to old arrow's position
            CLRR    R0                  ; |-- and clear the old arrow
            MVO@    R0,     R1          ;/

            SUBI    #3*20,  R1          ;\    Move to new arrow's position
            MVII    #ARROW, R0          ; |-- and draw the new arrow.
            MVO@    R0,     R1          ;/
            JR      R5                  ; return.

            ENDP

;; ======================================================================== ;;
;;  M_BLINK -- Blink the arrow on the menu.                                 ;;
;; ======================================================================== ;;

M_BLINK     PROC
            MVI     M_ROW,  R1          ; Get menu row
            ADDI    #$200 + 11, R1      ; Offset to arrow position
            MVII    #ARROW, R2          ;\
            XOR@    R1,     R2          ; |-- Toggle the arrow on and off.
            MVO@    R2,     R1          ;/
            JR      R5                  ; return.
            ENDP

;; ======================================================================== ;;
;;  GAMEOVER -- Game-over screen.                                           ;;
;; ======================================================================== ;;

GAMEOVER    PROC
            PSHR    R5

            ;; ------------------------------------------------------------ ;;
            ;;  Say "Game Over!"                                            ;;
            ;; ------------------------------------------------------------ ;;

            MVI     CAUGHT, R0
            CMPI    #0, R0
            BNEQ    @@caught

            CALL    IV_PLAY
            DECLE   PH_GAMEOVER
@@caught

            ;; ------------------------------------------------------------ ;;
            ;;  Make a long 'ding'.                                         ;;
            ;;  Channel A Period = $0200     Channel A Volume = Envelope    ;;
            ;;  Envelope Period  = $3FFF     Envelope type = 0000           ;;
            ;;  Enables = Tone only on A, B, C.                             ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #$02,   R1
            MVO     R1,     PSG0.chn_a_hi
            MVII    #$38,   R1
            MVO     R1,     PSG0.chan_enable
            MVO     R1,     PSG0.chn_a_vol
            MVII    #$FF,   R1
            MVO     R1,     PSG0.envlp_lo
            MVII    #$3F,   R1
            MVO     R1,     PSG0.envlp_hi
            CLRR    R1
            MVO     R1,     PSG0.chn_a_lo
            MVO     R1,     PSG0.envelope

            ;; ------------------------------------------------------------ ;;
            ;;  Show the "Game Over!" message.  Also show the skill level   ;;
            ;;  and game duration, in case the player wants to make a       ;;
            ;;  screen-shot.                                                ;;
            ;; ------------------------------------------------------------ ;;

            CALL    PRINT.FLS
            DECLE   C_BLK, $200 + 4*20 + 4
                    ;01234567890123456789
            STRING      " GAME OVER! ",0

            CALL    PRINT.FLS
            DECLE   C_BLU, $200 + 6*20 + 5
                    ;01234567890123456789
            STRING       "Skill:  ", 0

            MVI     SKILL,  R0
            MVII    #4, R1                               ; Amount of numbers to print
            MVII    #C_DGR, R3                           ; Color to print the message
            MVII    #$0283, R4                           ; Where to print the message; Over right the year
            JSR     R5, $18C5                            ; Print number in R0

            CALL    PRINT.FLS
            DECLE   C_BLU, $200 + 7*20 + 4
                    ;01234567890123456789
            STRING      "Length:  ", 0

            MVI     DURATION, R0
            MVII    #4, R1                               ; Amount of numbers to print
            MVII    #C_DGR, R3                           ; Color to print the message
            MVII    #$0297, R4                           ; Where to print the message; Over right the year
            JSR     R5, $18C5                            ; Print number in R0

            MVI     $0081,  R1          ; \
            RLC     R1,     2           ;  |-- See if we detect Intellivoice
            BOV     @@no_ivoice4        ; /    once we've reset it.

            CALL    PRINT.FLS
            DECLE   C_BLU, $200 + 8*20 + 4
                    ;01234567890123456789
            STRING      "  Cans:  ", 0

            MVI     SCORE, R0
            MVII    #4, R1                               ; Amount of numbers to print
            MVII    #C_DGR, R3                           ; Color to print the message
            MVII    #$02AB, R4                           ; Where to print the message; Over right the year
            JSR     R5, $18C5                            ; Print number in R0
@@no_ivoice4

            ;; ------------------------------------------------------------ ;;
            ;;  Force the MOBs to not update.  Clear them from the screen.  ;;
            ;; ------------------------------------------------------------ ;;

            MVO     PC,     MOB_BUSY

            MVII    #STICSH, R4
            MVII    #24,    R1
            CALL    FILLZERO

            ;; ------------------------------------------------------------ ;;
            ;;  Say "Final score"                                           ;;
            ;; ------------------------------------------------------------ ;;

;dddd
            MVI     CAUGHT, R0
            CMPI    #0, R0
            BEQ     @@notcaught


@@toodtop

            MVII    #C_BRN, R0
            MVO     R0, Color0      ; Set the color for the title screen
            MVO     R0, Color4      ; Set the border color

            CALL    CLRSCR

; Display the block gram cards on the title screen

            MVII  #$0216, R4
            MVII  #TITLELOGO+7, R0  ; block, left just.
@@loop1
            MVO@  R0, R4            ; write to BACKTAB
            DECR  R0                ; dec Color
            INCR  R4                ; skip space in between
            CMPI  #$021E, R4        ; midpoint?
            BNZE  @@loop1
            INCR  R4                ; skip 1 extra space
            MVII  #TITLELOGO-5, R0  ; right just. block (prev. GROM card)
@@loop2
            MVO@  R0, R4            ; write to BACKTAB
            DECR  R0                ; dec Color
            INCR  R4                ; skip space in between
            CMPI  #$0227, R4        ; last block?
            BNZE  @@loop2

; display the Mattel title screen

            MVII    #7, R3                    ; Color to print the text

            MVII    #$23D, R4                 ; Where the title goes
            JSR     R5, $187B
            BYTE    "Mattel Electronics", 0

            MVII    #$256, R4                 ; Where the copyright date goes
            JSR     R5, $187B
            BYTE    "presents", 0

            MVII    #$2C9, R4                 ; Where the copyright date goes
            JSR     R5, $187B
            BYTE    "Copr @ 1978 Mattel", 0

            CALL    IV_PLAY
            DECLE   PH_LETSPLAY

            MVII  #3, R0
            CALL  RAND                        ; R0 gets a random value range 0..7

            CMPI  #1, R0                      ; when 0 or 1
            BGT   @@2

            MVII    #$28C, R4                 ; Where the title name goes
            JSR     R5, $187B
            BYTE    "      BASEBALL      ", 0

            CALL  IV_PLAYW
            DECLE PH_BASEBALL                 ; voice BASEBALL
            J     @@done
@@2:
            CMPI  #3, R0                      ; when 2 or 3
            BGT   @@4

            MVII    #$28C, R4                 ; Where the title name goes
            JSR     R5, $187B
            BYTE    "     BASKETBALL     ", 0

            CALL  IV_PLAYW
            DECLE PH_BASKET                   ; voice BASKETBALL
            J     @@done
@@4:
            CMPI  #4, R0                      ; when 4
            BGT   @@5

            MVII    #$28C, R4                 ; Where the title name goes
            JSR     R5, $187B
            BYTE    "       HOCKEY       ", 0

            MVII    #$2D2, R4                 ; Where the copyright date goes
            JSR     R5, $187B
            BYTE    "79", 0

            CALL  IV_PLAYW
            DECLE PH_HOCKEY                   ; voice HOCKEY
            J     @@done
@@5:
            CMPI  #5, R0                      ; when 5
            BGT   @@6

            MVII    #$28C, R4                 ; Where the title name goes
            JSR     R5, $187B
            BYTE    "       TENNIS       ", 0

            MVII    #$2D2, R4                 ; Where the copyright date goes
            JSR     R5, $187B
            BYTE    "80", 0

            CALL  IV_PLAYW
            DECLE PH_TENNIS                   ; voice TENNIS
            J     @@done
@@6:                                          ; when 6 or 7
            MVII    #$28C, R4                 ; Where the title name goes
            JSR     R5, $187B
            BYTE    "       SOCCER       ", 0

            MVII    #$2D2, R4                 ; Where the copyright date goes
            JSR     R5, $187B
            BYTE    "79", 0

            CALL  IV_PLAYW
            DECLE PH_SOCCER                   ; voice SOCCER
@@done:

            B       @@donecaught

@@notcaught
            CALL    IV_PLAY
            DECLE   PH_FINAL

            CALL    IV_PLAY
            DECLE   PH_SCORE

            MVI     SCORE,  R0
            CALL    IV_SAYNUM16E

            MVI     SKILL,  R0               ; increase the level of play
            INCR    R0
            MVO     R0,     SKILL

@@donecaught

            ;; ------------------------------------------------------------ ;;
            ;;  Disable hand controllers for now, but schedule them to be   ;;
            ;;  set up in 2 seconds.  When they do get set up, pressing     ;;
            ;;  any key will go back to the menu.  This task is a one-shot. ;;
            ;; ------------------------------------------------------------ ;;

            CALL    STARTTASK
            DECLE   0
            DECLE   @@set_hexit
            DECLE   241,    241     ; Set up HEXIT as dispatch after 1 second

            CLRR    R0
            MVO     R0,     SHDISP  ; Until then, drop all controller input

            MVII    #1,     R0
            MVO     R0,     TSKACT

            PULR    PC              ; return to "RUNQ".


            ;; ------------------------------------------------------------ ;;
            ;;  This will get called in 1 second to set up the hand-        ;;
            ;;  controller dispatch.  The HEXIT dispatch will cause any     ;;
            ;;  keypress input to exit "GAME OVER" mode and go to the menu. ;;
            ;; ------------------------------------------------------------ ;;

@@set_hexit:
            MVII    #HEXIT, R0
            MVO     R0,     SHDISP
            JR      R5
            ENDP

;; ======================================================================== ;;
;;  GAME -- Set up the game state.                                          ;;
;; ======================================================================== ;;

GAME        PROC

            PSHR    R5

            ;; ------------------------------------------------------------ ;;
            ;;  Set up the display.                                         ;;
            ;; ------------------------------------------------------------ ;;
            CALL    CLRSCR


            CALL        init_song               ; initialize music
            DECLE       song00

;dddd
            MVI     $0081,  R1          ; \
            RLC     R1,     2           ;  |-- See if we detect Intellivoice
            BOV     @@no_ivoice         ; /    once we've reset it.
            B       @@done

@@no_ivoice
            MVII    #$2000, R0
            MVO     R0,     $200 + 11*20    ; Bottom row is blue

            CALL    PRINT.FLS
            DECLE   C_YEL,  $200 + 11*20 + 1
                    ;01234567890123456789
            STRING   "Time:     Cans:    ",0

            MVII    #$80 + C_WHT, R0
            MVO     R0,     $200 + 11*20 + 18   ; 0 in 'score'
@@done

            ;; ------------------------------------------------------------ ;;
            ;;  Set up our hand-controller dispatch.                        ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #HAND,  R0      ;\__ Set up scanhand dispatch table
            MVO     R0,     SHDISP  ;/

            ;; ------------------------------------------------------------ ;;
            ;;  Set up Todd's AI.                                           ;;
            ;; ------------------------------------------------------------ ;;

            CALL    STARTTASK
            DECLE   0
            DECLE   TODDTASK
            DECLE   120, 40         ; 3Hz (twice a second)

            ;; ------------------------------------------------------------ ;;
            ;;  Set up round timer.                                         ;;
            ;; ------------------------------------------------------------ ;;

            CALL    STARTTASK
            DECLE   1
            DECLE   GAMETIME
            DECLE   2, 120

            MVI     GAME_LEN, R0
            INCR    R0
            MVO     R0,     TIMELEFT

            ;; ------------------------------------------------------------ ;;
            ;;  Reset info for you and Todd.                                ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #PLYR,  R4
            MVII    #12,    R1
            CALL    FILLZERO

            ;; ------------------------------------------------------------ ;;
            ;;  Put you and Todd onscreen.                                  ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #$1000, R0
            MVO     R0,     PLYR.XP
            MVO     R0,     PLYR.YP

            MVII    #$9B00, R0
            MVO     R0,     TODD.XP
            MVII    #$5500, R0
            MVO     R0,     TODD.YP

            MVI     INIT_VEL,R0
            MVO     R0,     TODD_VEL

            ;; ------------------------------------------------------------ ;;
            ;;  Randomly display a dozen goodies.                           ;;
            ;; ------------------------------------------------------------ ;;

            CALL    DISPDOZ

            ;; ------------------------------------------------------------ ;;
            ;;  Enable MOBs.                                                ;;
            ;; ------------------------------------------------------------ ;;

            CLRR    R0
            MVO     R0,     MOB_BUSY

            ;; ------------------------------------------------------------ ;;
            ;;  Reset our score                                             ;;
            ;; ------------------------------------------------------------ ;;

            MVO     R0,     SCORE

            ;; ------------------------------------------------------------ ;;
            ;;  Todd says "Lets Play!"                                      ;;
            ;; ------------------------------------------------------------ ;;

            CALL    IV_PLAY
            DECLE   PH_LETSPLAY

            ;; ------------------------------------------------------------ ;;
            ;;  Start all the tasks only after Todd is done speaking.       ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #2,     R0
            MVO     R0,     TSKACT

            PULR    PC
            ENDP

;; ======================================================================== ;;
;;  DISPDOZ  -- Display a dozen goodies.                                    ;;
;; ======================================================================== ;;

DISPDOZ     PROC
            PSHR    R5

;DDDD

; Clear the fence only

            MVI     LEVEL,  R4
            ADDI    #$200-20,  R4
;DDDD            MVII    #$0200,R4           ; Fills memory with value in R1
            MVII    #$0000,R1           ; R4=starting address
            MVII    #020,R0             ; R1=value
            JSR     R5, $1741           ; R0=count

            MVII    #BG1,   R2          ; Value to write to display BG1.
            MVI     NUM_BG, R1          ; Number of BG images
            CALL    LOOP

            MVII    #BG2,   R2          ; Value to write to display BG2.
            MVI     NUM_BG, R1          ; Number of BG images
            CALL    LOOP

            MVII    #BG3,   R2          ; Value to write to display BG3.
            MVI     NUM_BG, R1          ; Number of BG images
            CALL    LOOP

            MVI     LEVEL,  R4
            ADDI    #$200,  R4
            MVII    #FENCE,R1           ; R4=starting address
            MVII    #20,R0              ; R1=value
            JSR     R5, $1741           ; R0=count

            MVII    #CAN,   R2          ; Value to write to display pop can.
            MVII    #12,    R1          ; dozen == 12.  :-)
            MVO     R1,     NUM_CANS    ; Re-initialize our can counter.
            CALL    LOOP

            PULR    PC
            ENDP

;; ======================================================================== ;;

LOOP        PROC
            PSHR    R5

@@gloop     MVII    #$8,    R0          ;\__ Generate 8 random bits
            CALL    RAND                ;/


            MVI     $0081,  R3          ; \
            RLC     R3,     2           ;  |-- See if we detect Intellivoice
            BOV     @@no_ivoice3        ; /    once we've reset it.
            CMPI    #20*12, R0          ; Clamp to < 219 (first 11 rows.)
            BGE     @@gloop             ; Too big?  Get another.
            B       @@done4
@@no_ivoice3
            CMPI    #20*11, R0          ; Clamp to < 219 (first 11 rows.)
            BGE     @@gloop             ; Too big?  Get another.
@@done4
            CMPI    #CAN,   R2          ; Is this the CAN procedure
            BNEQ    @@no_can

            MVI     LEVEL,  R3
            ADDI    #20,    R3          ; Clamp to LEVEL + 20 (row level + 1 row.)
            CMPR    R3,     R0
            BLE     @@gloop             ; Too big?  Get another.

@@no_can:
            ADDI    #$200,  R0          ; Make into a display offset.
            MOVR    R0,     R3          ; ... in a pointer-capable register
            CMP@    R3,     R2          ; Already a can there?
            BEQ     @@gloop             ; Yes:  Pick somewhere else.

            MVO@    R2,     R3          ; No:  Put an image there
            DECR    R1
            BNEQ    @@gloop

            PULR    PC
            ENDP

;; ======================================================================== ;;
;;  GAMETIME -- The game timer.  Counts down remaining time in game.        ;;
;; ======================================================================== ;;

GAMETIME    PROC

            ;; ------------------------------------------------------------ ;;
            ;;  Todd gradually gets faster.                                 ;;
            ;; ------------------------------------------------------------ ;;

            MVI     TODD_VEL, R0
            INCR    R0
            MVO     R0,     TODD_VEL

            ;; ------------------------------------------------------------ ;;
            ;;  Count down the timer.                                       ;;
            ;; ------------------------------------------------------------ ;;

            MVI     TIMELEFT, R0
            MVO     R0,     TIMELEFT
            DECR    R0
            BMI     SCHEDEXIT           ; Game is over if timer expires.
            MVO     R0,     TIMELEFT

            ;; ------------------------------------------------------------ ;;
            ;;  Make a short 'ding'.                                        ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #$40,   R1
            MVO     R1,     PSG0.chn_a_lo
            CLRR    R1
            MVO     R1,     PSG0.chn_a_hi
            MVII    #$38,   R1
            MVO     R1,     PSG0.chan_enable
            MVO     R1,     PSG0.chn_a_vol
            MVII    #$3F,   R1
            MVO     R1,     PSG0.envlp_lo
            CLRR    R1
            MVO     R1,     PSG0.envlp_hi
            MVO     R1,     PSG0.envelope

            ;; ------------------------------------------------------------ ;;
            ;;  Display 2-digit clock.  Time-left is still in R0.           ;;
            ;; ------------------------------------------------------------ ;;

            MVI     IV.QT,  R2          ; Get queue tail
            SWAP    R2,     2           ;\___ Leave if "no Intellivoice"
            BMI     @@no_ivoice         ;/    bit it set.

;dddd
            CMPI    #10, R0
            BGT     @@donesay
            MVO     R0, SAY_NUM
@@donesay
            JR      R5
@@no_ivoice:
            MVII    #3,     R2          ; 2-digit field
            MVII    #C_WHT, R3
            MVII    #$200+11*20+7, R4   ; Where to put time.
            B       DEC16A
            ENDP

;; ======================================================================== ;;
;;  SINTBL  -- Sine table.  sin(disc_dir) * 511                             ;;
;; ======================================================================== ;;

SINTBL      PROC
            DECLE   $0000
            DECLE   $00C3
            DECLE   $0169
            DECLE   $01D8
            DECLE   $01FF
            DECLE   $01D8
            DECLE   $0169
            DECLE   $00C3
            DECLE   $0000
            DECLE   $FF3D
            DECLE   $FE97
            DECLE   $FE28
            DECLE   $FE01
            DECLE   $FE28
            DECLE   $FE97
            DECLE   $FF3D
            ENDP

;; ======================================================================== ;;
;;  HAND    Dispatch table.                                                 ;;
;; ======================================================================== ;;

HAND        PROC
            DECLE   HIT_KEYPAD
            DECLE   HIT_ACTION
            DECLE   HIT_DISC
            ENDP

;; ======================================================================== ;;
;;  HIT_KEYPAD -- Someone hit a key on a keypad.                            ;;
;; ======================================================================== ;;

HIT_KEYPAD  PROC
            JR      R5
            ENDP

;; ======================================================================== ;;
;;  HIT_ACTION -- Someone hit a key on a keypad.                            ;;
;; ======================================================================== ;;

HIT_ACTION  PROC
            JR      R5
            ENDP

;; ======================================================================== ;;
;;  HIT_DISC   -- Someone hit a key on a keypad.                            ;;
;; ======================================================================== ;;

HIT_DISC    PROC
            PSHR    R5

            ANDI    #$FF,   R2      ; Ignore controller number
            CMPI    #$80,   R2
            BLT     @@pressed

            CLRR    R0
            MVO     R0,     PLYR.TXV
            MVO     R0,     PLYR.TYV
            MVII    #$FF, R0        ; Set the flag to stop the animation
            MVO     R0, DIRECTION
            PULR    PC

@@pressed:  MOVR    R2,     R1

            CMPI    #$FF, R2
            BEQ     @@noflag

            MVO R2, DIRECTION2  ;DDDD

@@noflag:
            MVO R2, DIRECTION  ;DDDD

            ADDI    #4,     R1
            ANDI    #$F,    R1
            ADDI    #SINTBL,R2          ; sine pointer
            ADDI    #SINTBL,R1          ; cosine pointer
            MVI@    R2,     R2          ; sine for our direction
            MVI@    R1,     R1          ; cosine for our direction
            NEGR    R2
            SARC    R1                  ; slow down a bit
            SARC    R2                  ; slow down a bit
            MVO     R2,     PLYR.TYV    ; Set our target Y velocity to sine
            MVO     R1,     PLYR.TXV    ; Set our target X velocity to cosine

            PULR    PC

            ENDP

;; ======================================================================== ;;
;;  TODDTASK   -- Todd wants to find you!                                   ;;
;; ======================================================================== ;;

TODDTASK    PROC

            ;; ------------------------------------------------------------ ;;
            ;;  This is really simple:  Todd will pick one of 8 directions  ;;
            ;;  to walk in to try to move towards you.  He picks this only  ;;
            ;;  based on whether you're left/right or above/below him.      ;;
            ;; ------------------------------------------------------------ ;;

            CLRR    R0                  ; set X vel to 0
            CLRR    R1                  ; set Y vel to 0
            MVI     PLYR.XP,    R2
            MVI     TODD.XP,    R3
            SLR     R2,         2
            SLR     R3,         2

            CMPR    R3,         R2
            BEQ     @@xp0               ; Equal?  X-vel stays 0
            MVI     TODD_VEL,   R0      ; Player > Todd?  Move right
            BGT     @@xp0               ; Player < Todd?  Move left
            NEGR    R0
@@xp0

            SUBR    R3,         R2      ;\
            BPL     @@dx_pos            ; |
            NEGR    R2                  ; |__ If X coords are close enough
@@dx_pos    CMPI    #2,         R2      ; |   anyway, force target Xvel to 0
            BGE     @@xp_ok             ; |
            CLRR    R0                  ;/
@@xp_ok
            MVI     PLYR.YP,    R2
            MVI     TODD.YP,    R3
            SLR     R2,         2
            SLR     R3,         2

            CMPR    R3,         R2
            BEQ     @@yp0               ; Equal?  X-vel stays 0
            MVI     TODD_VEL,   R1      ; Player > Todd?  Move right
            BGT     @@yp0               ; Player < Todd?  Move left
            NEGR    R1
@@yp0
            SUBR    R3,         R2      ;\
            BPL     @@dy_pos            ; |
            NEGR    R2                  ; |__ If Y coords are close enough
@@dy_pos    CMPI    #2,         R2      ; |   anyway, force target Yvel to 0
            BGE     @@yp_ok             ; |
            CLRR    R1                  ;/
@@yp_ok
            MVO     R0,     TODD.TXV    ; Set Todd's target X velocity
            MVO     R1,     TODD.TYV    ; Set Todd's target Y velocity

            JR      R5                  ; Leave
            ENDP

;; ======================================================================== ;;
;;  MOB_UPDATE -- This updates the player's and Todd's position and vel.    ;;
;; ======================================================================== ;;

MOB_UPDATE  PROC
            PSHR    R5

;dddd
            MVI     SAY_NUM,    R0
            CMPI    #0,         R0
            BEQ     @@no_ivoice
            CLRR    R0
            MVO     R0, SAY_NUM

            MVI     IV.QT,  R2          ; Get queue tail
            SWAP    R2,     2           ;\___ Leave if "no Intellivoice"
            BMI     @@no_ivoice         ;/    bit it set.

            MVI     TIMELEFT, R0
            CALL    IV_SAYNUM16I
@@no_ivoice:


            ;; ------------------------------------------------------------ ;;
            ;;  Bring our actual velocity closer to our target velocity,    ;;
            ;;  and apply the velocity to our position.  The routine        ;;
            ;;  @@update_velocity takes a pointer to a record with target   ;;
            ;;  velocity, current velocity, and current position.  It       ;;
            ;;  returns with R0 == current velocity, and R3 pointing to     ;;
            ;;  the current velocity location.                              ;;
            ;; ------------------------------------------------------------ ;;

            CALL    @@update_velocity   ; Update player's X velocity
            DECLE   PLYR.TXV
            INCR    R3                  ; Point to X position
            ADD@    R3,     R0          ; Add position to velocity
            CALL    @@clipx             ; Clip X position to display
            MVO@    R0,     R3          ; Store updated position

            CALL    @@update_velocity   ; Update player's Y velocity
            DECLE   PLYR.TYV
            INCR    R3                  ; Point to Y position
            ADD@    R3,     R0          ; Add position to velocity
            CALL    @@clipy             ; Clip Y position to display
            MVO@    R0,     R3          ; Store updated position

;xxxx remark to stop todd from running

            CALL    @@update_velocity   ; Update Todd's X velocity
            DECLE   TODD.TXV
            INCR    R3                  ; Point to X position
            ADD@    R3,     R0          ; Add position to velocity
            CALL    @@clipx             ; Clip X position to display
            MVO@    R0,     R3          ; Store updated position

            CALL    @@update_velocity   ; Update Todd's Y velocity
            DECLE   TODD.TYV
            INCR    R3                  ; Point to Y position
            ADD@    R3,     R0          ; Add position to velocity
            CALL    @@clipy             ; Clip Y position to display
            MVO@    R0,     R3          ; Store updated position

            ;; ------------------------------------------------------------ ;;
            ;;  Merge our position with our MOB registers.                  ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #STICSH,    R5

            MVII    #@@mobx1,   R4      ; MOB information template
            MVI     PLYR.XP,    R0      ;\
            SWAP    R0                  ; |
            ANDI    #$00FF,     R0      ; |- Player X position
            XOR@    R4,         R0      ; |
            MVO@    R0,         R5      ;/

            MVII    #@@mobx2,   R4      ; MOB information template
            MVI     TODD.XP,    R0      ;\
            SWAP    R0                  ; |
            ANDI    #$00FF,     R0      ; |- Todd X position
            XOR@    R4,         R0      ; |
            MVO@    R0,         R5      ;/

            ADDI    #6,         R5

;dddd

            MVI DIRECTION2, R0

@@east1:
            CMPI    #3,     R0
            BGT     @@east               ; East (directions 0, 1, 2)

            MVII    #@@moby1e,   R4      ; MOB information template
            J       @@done_moby1

@@east:
            CMPI    #12,    R0
            BLT     @@west              ; East (directions 13, 14, 15)
            MVII    #@@moby1e,   R4      ; MOB information template
            J       @@done_moby1

@@west:
           MVII    #@@moby1w,   R4      ; MOB information template


@@done_moby1:

            MVI     PLYR.YP,    R0      ;\
            SWAP    R0                  ; |
            ANDI    #$007F,     R0      ; |- Player Y position
            XOR@    R4,         R0      ; |
            MVO@    R0,         R5      ;/



; todds direction

            MVI     PLYR.XP,    R0
            MVI     TODD.XP,    R1
            SLR     R0,         2
            SLR     R1,         2

            CMPR    R1,         R0
            BLT     @@xp0                ; Player < Todd?  Move left
            MVII    #@@moby2e,   R4      ; MOB information template
            J       @@done_moby2
@@xp0

            MVII    #@@moby2w,   R4      ; MOB information template

@@done_moby2

            MVI     TODD.YP,    R0      ;\
            SWAP    R0                  ; |
            ANDI    #$007F,     R0      ; |- Todd Y position
            XOR@    R4,         R0      ; |
            MVO@    R0,         R5      ;/

            ADDI    #6,         R5

;dddd

            MVI DIRECTION, R0

@@north1:
            CMPI    #2,     R0
            BGT     @@north              ; North directions 3, 4, 5

            MVII    #@@moba1,    R4      ; MOB information template LEFT/RIGHT
            J       @@done_moba1

@@north:
            CMPI    #5,    R0
            BGT     @@south1             ; North directions 3, 4, 5
            MVII    #@@moba1a,    R4     ; MOB information template UP/DOWN
            J       @@done_moba1

@@south1:
            CMPI    #10,     R0
            BGT     @@south              ; South directions 11, 12, 13
            MVII    #@@moba1,    R4      ; MOB information template LEFT/RIGHT
            J       @@done_moba1

@@south:
            CMPI    #13,     R0
            BGT     @@east2              ; South directions 11, 12, 13
            MVII    #@@moba1a,    R4     ; MOB information template UP/DOWN
            J       @@done_moba1

@@east2:
            CMPI    #15,     R0
            BGT     @@standing           ; East directions 14, 15, 0, 1, 2
            MVII    #@@moba1,    R4      ; MOB information template LEFT/RIGHT
            J       @@done_moba1


@@standing:
            MVII    #@@moba2,    R4      ; MOB information template STANDING


@@done_moba1:
            MVI@    R4,         R0      ; \_ Player's A register

;DDDD
            MVI     DIRECTION, R1
            CMPI    #$FF,         R1
            BEQ     @@nomove

            MVI     SPRITE, R1
            INCR    R1
            INCR    R1                  ; use mutiple INCR to change the running speed
            MVO     R1, SPRITE

            ANDI    #00011100b, R1
            SLL     R1, 2
            XORR    R1, R0                               ; merge the GRAM Card value we computed above

@@nomove:
            MVO@    R0,         R5      ; /
            MVI@    R4,         R0      ; \_ Todd's A register

            MVI     SPRITE1, R1
            INCR    R1                  ; use mutiple INCR to change the running speed
            MVO     R1, SPRITE1

            ANDI    #00011100b, R1
            SLL     R1, 2
            XORR    R1, R0                               ; merge the GRAM Card value we computed above

            MVO@    R0,         R5      ; /

            CLRR    R0
            MVO     R0,         MOB_BUSY

            ;; ------------------------------------------------------------ ;;
            ;;  See if we're on a pop can.                                  ;;
            ;; ------------------------------------------------------------ ;;

            MVI     PLYR.YP,R1      ;\
            SWAP    R1              ; |
            SUBI    #4,     R1      ; |
            ANDI    #$F8,   R1      ; |
            MOVR    R1,     R2      ; |-- Generate row offset from Y coord.
            ADDR    R1,     R2      ; |
            SLR     R1,     1       ; |
            ADDR    R1,     R2      ;/

            MVI     PLYR.XP,R1      ;\
            SWAP    R1              ; |
            SUBI    #4,     R1      ; |
            ANDI    #$F8,   R1      ; |-- Generate column offset from X coord.
            SLR     R1,     2       ; |
            SLR     R1,     1       ; |
            ADDR    R1,     R2      ;/

            ADDI    #$200,  R2      ; Index into screen
            MVI@    R2,     R1
            CMPI    #CAN,   R1      ; A pop can here?
            BNEQ    @@no_can

            CLRR    R1
            MVO@    R1,     R2      ; Pick it up (clear it from screen)

            MVI     SCORE,  R0
            INCR    R0
            MVO     R0,     SCORE   ; Add 1 to score


            ;; ------------------------------------------------------------ ;;
            ;;  Make a short 'can clash'.                                   ;;
            ;; ------------------------------------------------------------ ;;

            MVII    #$01,   R1
            MVO     R1,     PSG0.chn_b_lo
            CLRR    R1
            MVO     R1,     PSG0.chn_b_hi

            MVII    #$01,   R1
            MVO     R1,     PSG0.chan_enable

            MVII    #$FF,   R1
            MVO     R1,     PSG0.chn_b_vol

            MVII    #$02,   R1
            MVO     R1,     PSG0.envlp_hi
            MVO     R1,     PSG0.envelope

;dddd
            MVI     $0081,  R1          ; \
            RLC     R1,     2           ;  |-- See if we detect Intellivoice
            BOV     @@no_ivoice2         ; /    once we've reset it.
            B       @@done3

@@no_ivoice2
            MVII    #$200+11*20+16, R4
            MVII    #$2,    R2      ; 3-digit field
            MVII    #C_WHT+$8000,R3 ; no leading zeros, score in white
            CALL    DEC16           ; Show updated score
@@done3

            MVI     NUM_CANS, R0    ;\
            DECR    R0              ; |-- Decrement remaining can count
            MVO     R0, NUM_CANS    ;/
            BNEQ    @@some_left

            MVI     LEVEL,  R0
            CMPI    #100,    R0
            BEQ     @@skip
            ADDI    #20,    R0          ; add 20 to display the fence on the following line
            MVO     R0,     LEVEL

            MVI     TBORDER, R0
            ADDI    #$800,  R0          ; add 2304 to the top border value
            MVO     R0,     TBORDER
@@skip:

            CALL    DISPDOZ         ; Display another dozen if we run out.
@@some_left:
@@no_can:

            ;; ------------------------------------------------------------ ;;
            ;;  See if Todd's caught us.  He's caught us if our coords are  ;;
            ;;  both within 4 pixels of each other.  This tight tolerance   ;;
            ;;  allows us to brush past Todd and not get caught.  :-)       ;;
            ;; ------------------------------------------------------------ ;;

            MVI     PLYR.XP,R0
            SUB     TODD.XP,R0
            ADCR    PC              ; skip NEGR if diff is positive
            NEGR    R0              ; make diff positive
            CMPI    #$400,  R0
            BC      @@todd_ok

            MVI     PLYR.YP,R0
            SUB     TODD.YP,R0
            ADCR    PC              ; skip NEGR if diff is positive
            NEGR    R0              ; make diff positive
            CMPI    #$400,  R0
            BC      @@todd_ok

            MVII    #1,     R0
            MVO     R0,     CAUGHT

  CALL  temporize
  DECLE 20000

            PULR    R5
            B       SCHEDEXIT       ; If Todd catches up to us, it's gameover

@@todd_ok:
            PULR    PC

            ;; ------------------------------------------------------------ ;;
            ;;  Bits to copy into MOB registers.                            ;;
            ;; ------------------------------------------------------------ ;;

@@mobx1:
            DECLE   STIC.mobx_visb      ; make player visible
            JR      R5

@@moby1e:
            DECLE   STIC.moby_yres      ; make player 8x16 MOB running ease
            JR      R5
@@moby1w:
            DECLE   STIC.moby_xflip + STIC.moby_yres      ; make player 8x16 MOB running west
            JR      R5

@@mobx2:
            DECLE   STIC.mobx_visb      ; make Todd visible
            JR      R5

@@moby2e:
            DECLE   STIC.moby_yres      ; make Todd 8x16 MOB running east
            JR      R5

@@moby2w:
            DECLE   STIC.moby_xflip + STIC.moby_yres      ; make Todd 8x16 MOB running west
            JR      R5

@@moba1:    ; left/right GRAM
            DECLE   STIC.moba_fg1 + STIC.moba_gram + 0*8   ; Player is blue
            DECLE   STIC.moba_fg0 + STIC.moba_gram + 0*8   ; Todd is black
            JR      R5

@@moba1a:   ; up/down GRAM
            DECLE   STIC.moba_fg1 + STIC.moba_gram + 16*8   ; Player is blue
            DECLE   STIC.moba_fg0 + STIC.moba_gram + 0*8    ; Todd is black
            JR      R5

@@moba2:    ; left/right GRAM
            DECLE   STIC.moba_fg1 + STIC.moba_gram + 34*8   ; Player is blue
            DECLE   STIC.moba_fg0 + STIC.moba_gram + 0*8    ; Todd is black
            JR      R5

            ;; ------------------------------------------------------------ ;;
            ;;  Velocity update.  Add 1/4th the difference of our target    ;;
            ;;  velocity to our actual velocity.  We round the difference   ;;
            ;;  towards larger magnitude (eg. up if +ve, down if -ve) so    ;;
            ;;  that this finally converges on our target velocity.         ;;
            ;; ------------------------------------------------------------ ;;

@@update_velocity:
            MVI@    R5,         R3      ; Addr of target and current velocity
            MVI@    R3,         R0      ; Get target velocity
            INCR    R3                  ; Point to current velocity
            SUB@    R3,         R0      ; Find diff between target and current
            BMI     @@round_dn          ; Round -ve to -oo
            ADDI    #3,         R0      ; Round +ve to +oo
@@round_dn  SARC    R0,         2       ; Divide by 4 (right-shift by 2)
            ADD@    R3,         R0      ; Add update to current velocity
            MVO@    R0,         R3      ; Make updated velocity current.
            JR      R5

            ;; ------------------------------------------------------------ ;;
            ;;  Clipping code.  clipx clips for X dimension, clipy clips    ;;
            ;;  for Y dimension.  Goal:  Keep player and Todd onscreen.     ;;
            ;; ------------------------------------------------------------ ;;

@@clipx     CMPI    #$0900,     R0      ;\
            BC      @@xt_ok             ; |
            MVII    #$0900,     R0      ; |
            JR      R5                  ; |__ Limit X to 9 <= X <= 158
@@xt_ok     CMPI    #$9F00,     R0      ; |   (Note unsigned compares)
            BNC     @@xb_ok             ; |
            MVII    #$9F00,     R0      ; |
@@xb_ok     JR      R5                  ;/

@@clipy
            MVI     TBORDER,    R1      ;\
            CMPR    R1,         R0      ; |
            BC      @@yt_ok             ; |
            MVI     TBORDER,    R0      ; |
            JR      R5                  ; |__ Limit Y to 9 <= Y <= 86
@@yt_ok
            MVI     $0081,  R1          ; \
            RLC     R1,     2           ;  |-- See if we detect Intellivoice
            BOV     @@no_ivoice1        ; /    once we've reset it.

            CMPI    #$6000,     R0      ; |   (Note unsigned compares)
            BNC     @@yb_ok             ; |
            MVII    #$6000,     R0      ; |
            JR      R5                  ;/
@@no_ivoice1
            CMPI    #$5800,     R0      ; |   (Note unsigned compares)
            BNC     @@yb_ok             ; |
            MVII    #$5800,     R0      ; |
@@yb_ok     JR      R5                  ;/

            ENDP


;; ======================================================================== ;;
;;  ISR -- Just keep the screen on, and copy the STIC shadow over.          ;;
;; ======================================================================== ;;
ISR         PROC

            CALL        play                    ; play music


            ;; ------------------------------------------------------------ ;;
            ;;  Basics:  Update color stack and video enable.               ;;
            ;; ------------------------------------------------------------ ;;
            MVO     R0,     STIC.viden  ; Enable display
            MVI     STIC.mode, R0       ; ...in color-stack mode


            MVI     Color0, R0          ;\___ Set main display
            MVO     R0,     STIC.cs0    ;/
            MVI     Color1, R0
            MVO     R0,     STIC.cs1    ;\___ Set border
            MVI     Color2, R0
            MVO     R0,     STIC.cs2    ;\___ Set border
            MVI     Color3, R0
            MVO     R0,     STIC.cs3    ;\___ Set border
            MVI     Color4, R0
            MVO     R0,     STIC.bord   ;/

            ;; ------------------------------------------------------------ ;;
            ;;  Update STIC shadow and queue updates for MOB velocities.    ;;
            ;; ------------------------------------------------------------ ;;

            CALL    MEMCPY              ;\__ Copy over the STIC shadow.
            DECLE   $0000, STICSH, 24   ;/

            MVI     MOB_BUSY, R0        ; Skip MOB updates if told to.
            TSTR    R0
            BNEQ    @@no_mobs
            MVO     PC,     MOB_BUSY

            MVII    #MOB_UPDATE, R0
            JSRD    R5,   QTASK     ; Note JSRD:  Must disable ints for QTASK!
@@no_mobs:

            ;; ------------------------------------------------------------ ;;
            ;;  Feed the Intellivoice.                                      ;;
            ;; ------------------------------------------------------------ ;;
            CALL    IV_ISR

            ;; ------------------------------------------------------------ ;;
            ;;  Update timer-based tasks and return via stock interrupt     ;;
            ;;  return code.                                                ;;
            ;; ------------------------------------------------------------ ;;
            MVII    #$1014, R5          ; return from interrupt address.
            B       DOTIMER             ; Update timer-based tasks.
            ENDP

;; ======================================================================== ;;
;;  INITISR -- Copy our GRAM image over, and then do the plain ISR.         ;;
;; ======================================================================== ;;
INITISR     PROC
            PSHR    R5

            CALL    MEMUNPK
            DECLE   $3800, GRAMIMG, GRAMIMG.end - GRAMIMG

            MVII    #ISR,   R0
            MVO     R0,     ISRVEC
            SWAP    R0
            MVO     R0,     ISRVEC + 1

            PULR    PC
            ENDP


;------------------------------------------------------------------------------
; Pause routine
;------------------------------------------------------------------------------

temporize   PROC

  MVI@  R5, R0
  PSHR  R5

@@tprz:
  PSHR  R0
  PULR  R0
  DECR  R0
  BNEQ  @@tprz

  PULR  R7
  ENDP

;------------------------------------------------------------------------------

;; ======================================================================== ;;
;;  LIBRARY INCLUDES                                                        ;;
;; ======================================================================== ;;
            INCLUDE "0phrases.asm"   ; Contains the voice phrases
            INCLUDE "0graphics.asm"  ; Contains the graphic cards

            INCLUDE "print.asm"      ; PRINT.xxx routines
            INCLUDE "fillmem.asm"    ; CLRSCR/FILLZERO/FILLMEM
            INCLUDE "memcpy.asm"     ; MEMCPY
            INCLUDE "memunpk.asm"    ; MEMUNPK
            INCLUDE "rand.asm"       ; RAND
            INCLUDE "dec16only.asm"  ; DEC16
            INCLUDE "scanhand.asm"   ; SCANHAND
            INCLUDE "timer.asm"      ; Timer-based task stuff
            INCLUDE "taskq.asm"      ; RUNQ/QTASK
            INCLUDE "ivoice.asm"     ; IV_xxx routines.
            INCLUDE "saynum16.asm"   ; IV_SAYNUM16
            INCLUDE "al2.asm"        ; AL2 allophone library.

            INCLUDE     "tracker.asm"
            INCLUDE     "music.asm"
