; ========================================================================== ;
;                               .: Columns :.                                ;
;                     Intellivision ROM by A.Chevallier                      ;
; -------------------------------------------------------------------------- ;
;                       Mail : a_chevallier@yahoo.com                        ;
;                       Web  : http://knox.ac.free.fr                        ;
; ========================================================================== ;


; Variables
; --------------------------------------------------------------------------

RFRSH_M     EQU         $0150
NOTE_A      EQU         $0151
NOTE_B      EQU         $0152
NOTE_C      EQU         $0153
RFRSH_A     EQU         $0154
RFRSH_B     EQU         $0155
RFRSH_C     EQU         $0156
VOL_A       EQU         $0157
VOL_B       EQU         $0158
VOL_C       EQU         $0159
INSTR_A     EQU         $015A
INSTR_B     EQU         $015B
INSTR_C     EQU         $015C
COUNT_A     EQU         $015D
COUNT_B     EQU         $015E
COUNT_C     EQU         $015F
COUNT_M     EQU         $0160
COUNT_P     EQU         $0161
PAT         EQU         $0162

SONG        EQU         $0350
INSTR_PTR   EQU         $0351
POS_A       EQU         $0352
POS_B       EQU         $0353
POS_C       EQU         $0354

; Constants
; --------------------------------------------------------------------------

RFRSH2POS   EQU         (POS_A - RFRSH_A) AND $FFFF
POS2NOTE    EQU         (POS_A - NOTE_A)  AND $FFFF
POS2INSTR   EQU         (INSTR_A - POS_A) AND $FFFF
INSTR2PER   EQU         ($01F0 - INSTR_A) AND $FFFF
PER2COUNT   EQU         (COUNT_A - $01F4) AND $FFFF
VOL2VOL     EQU         ($01FB - VOL_A)   AND $FFFF


; -------------------------------------------------------------------------- ;
; [ init_psg ]                                                               ;
; -------------------------------------------------------------------------- ;
; Initialize the PSG                                                         ;
; -------------------------------------------------------------------------- ;

init_psg    PROC

            CLRR        R0
            MVO         R0,         SONG

            MVII        #$01F0,     R4
            MVO@        R0,         R4          ; $01F0
            MVO@        R0,         R4          ; $01F1
            MVO@        R0,         R4          ; $01F2

            INCR        R4
            MVO@        R0,         R4          ; $01F4
            MVO@        R0,         R4          ; $01F5
            MVO@        R0,         R4          ; $01F6

            MVII        #$01FB,     R4
            MVO@        R0,         R4          ; $01FB
            MVO@        R0,         R4          ; $01FC
            MVO@        R0,         R4          ; $01FD

            MVII        #$38,       R0
            MVO         R0,         $01F8

            MOVR        R5,         R7
            ENDP

; -------------------------------------------------------------------------- ;
; [ init_song ]                                                              ;
; -------------------------------------------------------------------------- ;
; Initialize a song                                                          ;
; -------------------------------------------------------------------------- ;

init_song   PROC

            CLRR        R0                      ; initialize variables
            MVO         R0,         RFRSH_M
            MVO         R0,         COUNT_M
            MVO         R0,         PAT
            NOP
            MVO         R0,         RFRSH_A
            MVO         R0,         RFRSH_B
            MVO         R0,         RFRSH_C

            MVII        #1,         R0
            MVO         R0,         G_FADE      ; default volume fade

            MVI@        R5,         R1          ; read song address
            MVO         R1,         SONG        ; and save it

            ADDI        #2,         R1          ; read pointer to instruments
            MVI@        R1,         R1
            MVO         R1,         INSTR_PTR   ; and save it

            ENDP

; initialize next pattern
; --------------------------------------------------------------------------

init_pat    PROC

            MVI         SONG,       R4
            INCR        R4
            MVI@        R4,         R2          ; R2 = address of 1st pattern
            INCR        R4
            MVI         PAT,        R0          ; R0 = position in patterns order table
            ADDR        R0,         R4

            MVI@        R4,         R1          ; R1 = pattern number
            TSTR        R1
            BPL         @@pat_ok                ; restart ?

            ADDR        R1,         R0          ; jump to restart position ...
            ADDR        R1,         R4
            DECR        R4
            MVI@        R4,         R1          ; ... and read again

@@pat_ok:   INCR        R0                      ; increment position
            MVO         R0,         PAT         ; in patterns order table

            SLL         R1,         2           ; R4 = R1 * 4 + R2
            MOVR        R1,         R4          ; (beginning of pattern's detail)
            ADDR        R2,         R4

            MVI@        R4,         R0          ; init. pattern counter
            MVO         R0,         COUNT_P

            MVI@        R4,         R0          ; init. position for each channel
            MVO         R0,         POS_A
            MVI@        R4,         R0
            MVO         R0,         POS_B
            MVI@        R4,         R0
            MVO         R0,         POS_C

            MOVR        R5,         R7
            ENDP

; -------------------------------------------------------------------------- ;
; [ play ]                                                                   ;
; -------------------------------------------------------------------------- ;
; Update the current song                                                    ;
; -------------------------------------------------------------------------- ;

play        PROC
            PSHR        R5

            MVI         SONG,       R4          ; is a song playing ?
            TSTR        R4
            BEQ         @@done

            MVI         COUNT_M,    R0          ; global music counter
            INCR        R0
            MVO         R0,         COUNT_M

            MVI         RFRSH_M,    R0          ; refresh notes ?
            DECR        R0
            BPL         @@notes_ok

            MVI@        R4,         R0          ; ... yes : read speed
            MVO         R0,         RFRSH_M

            MVII        #RFRSH_A,   R3          ; refresh note for each channel
            CALL        upd_ch
            BC          @@upd_b

            MVII        #$38,       R0
            MVO         R0,         $1F8

@@upd_b:    MVII        #RFRSH_B,   R3
            CALL        upd_ch
            MVII        #RFRSH_C,   R3
            CALL        upd_ch

            MVI         COUNT_P,    R0          ; pattern counter
            DECR        R0
            MVO         R0,         COUNT_P
            BNEQ        @@upd_psg               ; jump to next pattern ?

            CALL        init_pat                ; ... yes
            B           @@upd_psg

@@notes_ok: MVO         R0,         RFRSH_M

@@upd_psg:  MVII        #NOTE_A,    R3          ; update PSG for each channel
            CALL        upd_psg
            MVII        #NOTE_B,    R3
            CALL        upd_psg
            MVII        #NOTE_C,    R3
            CALL        upd_psg

@@done:     PULR        R7
            ENDP

; -------------------------------------------------------------------------- ;
; [ upd_ch ]                                                                 ;
; -------------------------------------------------------------------------- ;
; Update a channel                                                           ;
; -------------------------------------------------------------------------- ;

upd_ch      PROC
            PSHR        R5

            MVI@        R3,         R0          ; (R3 = RFRSH_x)
            SUBI        #$10,       R0
            BMI         @@ch_new

            MVO@        R0,         R3
            PULR        R7

@@ch_new:   ADDI        #RFRSH2POS, R3          ; read pos
            MVI@        R3,         R4
            MVI@        R4,         R0          ; read data

            MOVR        R0,         R1          ; extra data to read ? ...
            BPL         @@data_ok

            MVI@        R4,         R2          ; ... yes : R2 = new instrument
            ADDI        #POS2INSTR, R3
            MVO@        R2,         R3          ; save it
            SUBI        #POS2INSTR, R3

@@data_ok:  MVO@        R4,         R3          ; update pos

            SWAP        R0                      ; save note
            SUBI        #POS2NOTE,  R3
            ANDI        #$7F,       R0
            BEQ         @@skip_sav

            MVO@        R0,         R3

@@skip_sav: ADDI        #3,         R3          ; new refresh value (R3 = RFRSH_x)
            MVO@        R1,         R3

            ANDI        #$F,        R1          ; new volume
            ADDI        #3,         R3          ; (R3 = VOL_x)
            MVO@        R1,         R3

            TSTR        R0                      ; if note = 0,
            BEQ         @@ch_ok                 ; don't reset counter

            ADDI        #6,         R3          ; (R3 = COUNT_x)
            CLRR        R0                      ; reset counter
            MVO@        R0,         R3

@@ch_ok:    PULR        R7
            ENDP

; -------------------------------------------------------------------------- ;
; [ upd_psg ]                                                                ;
; -------------------------------------------------------------------------- ;
; Update the PSG                                                             ;
; -------------------------------------------------------------------------- ;

upd_psg     PROC

            MVI@        R3,         R1          ; read note

            ADDI        #12,        R3          ; (R3 = COUNT_x)
            MVI@        R3,         R2          ; read channel counter -> R2
            CMPI        #$FF,       R2          ; prevents loop after $FF
            BEQ         @@cnt_ok

            INCR        R2                      ; increment counter
            MVO@        R2,         R3
            DECR        R2

@@cnt_ok:   CMPI        #85,        R1          ; drum ?
            BGE         @@drum

; standard instrument
; --------------------------------------------------------------------------

            SUBI        #3,         R3          ; (R3 = INSTR_x)
            MVI@        R3,         R4          ; R4 = pointer to instrument
            ADD         INSTR_PTR,  R4

            PSHR        R2                      ; apply pitch effect
            ANDI        #3,         R2
            ADD@        R4,         R2
            ADD@        R2,         R1

            ADDI        #(notes-1), R1          ; read period from notes table
            MVI@        R1,         R0          ; R0 = period

            ADDI        #84,        R1          ; read vibrato amplitude for this note
            MVI@        R1,         R1          ; R1 = vibrato amplitude

            MVI@        R4,         R2          ; R2 = type of vibrato for this channel
            CMPI        #1,         R2
            BLT         @@vibr0                 ; no vibrato ?
            BEQ         @@low_vibr              ; low vibrato ?

            CMPI        #2,         R2
            BGT         @@apply_vb              ; high vibrato --> amplitude unchanged

            SLR         R1                      ; medium vibrato --> 1/2 amplitude
            INCR        R7

@@low_vibr: SLR         R1,         2           ; low vibrato --> 1/4 amplitude

@@apply_vb: MVI         COUNT_M,    R2          ; apply vibrato
            ANDI        #7,         R2          ; according to current step
            ADDI        #@@vb_ndx,  R2          ; (i.e. COUNT_M % 8)
            MVI@        R2,         R7

@@vb_ndx:   DECLE       @@vibr1, @@vibr2        ; vibrato processing index
            DECLE       @@vibr0, @@vibr3
            DECLE       @@vibr4, @@vibr3
            DECLE       @@vibr0, @@vibr2

@@vibr1:    SUBR        R1,         R0          ; - amplitude
            B           @@vibr0

@@vibr2:    SLR         R1                      ; - 1/2 amplitude
            SUBR        R1,         R0
            B           @@vibr0

@@vibr3:    SLR         R1                      ; + 1/2 amplitude
            ADDR        R1,         R0
            INCR        R7

@@vibr4:    ADDR        R1,         R0          ; + amplitude

@@vibr0:    ADDI        #INSTR2PER, R3          ; write period
            MVO@        R0,         R3          ; (low)
            SWAP        R0
            ADDI        #4,         R3
            MVO@        R0,         R3          ; (high)
            ADDI        #PER2COUNT, R3

            PULR        R0                      ; R0 = channel counter / 2
            SLR         R0

@@env:      MVI@        R4,         R4          ; R4 = pointer to envelope

            ADD@        R4,         R7          ; apply speed of envelope
            SLR         R0
            SLR         R0
            SLR         R0

            MOVR        R0,         R1          ; get volume from envelope
            SLR         R0,         2
            ADDR        R0,         R4
            MVI@        R4,         R0
            ANDI        #3,         R1
            ADDI        #@@env_ndx, R1
            MVI@        R1,         R7

@@env_ndx:  DECLE       @@env0, @@env1
            DECLE       @@env2, @@env3

@@env1:     SWAP        R0
            B           @@env3

@@env0:     SWAP        R0

@@env2:     SLR         R0,         2
            SLR         R0,         2

@@env3:     ANDI        #$F,        R0

            SUBI        #6,         R3          ; (R3 = VOL_x)
            SUB@        R3,         R0          ; get volume from song
            SUB         G_FADE,     R0
            BPL         @@upd_vol

            CLRR        R0

@@upd_vol:  ADDI        #VOL2VOL,   R3          ; apply new volume
            MVO@        R0,         R3

            CLRC
            MOVR        R5,         R7

; drum
; --------------------------------------------------------------------------

@@drum:     CMPI        #8,         R2
            BGE         @@end_drum

            SUBI        #85-3*4,    R1          ; get pointer to drum data
            ADD         INSTR_PTR,  R1
            MVI@        R1,         R4
            SLL         R2,         2
            ADDR        R2,         R4

            MVI@        R4,         R0          ; tone period
            MVO         R0,         $1F0
            SWAP        R0
            MVO         R0,         $1F4

            MVI@        R4,         R0          ; noise period
            MVO         R0,         $1F9

            MVI@        R4,         R0          ; enable tone / noise
            MVO         R0,         $1F8

            MVI@        R4,         R0          ; volume
            SUB         G_FADE,     R0
            BPL         @@drum_vol

            CLRR        R0

@@drum_vol: MVO         R0,         $1FB

            SETC
            MOVR        R5,         R7

@@end_drum: CLRR        R0
            MVO         R0,         $1FB

            SETC
            MOVR        R5,         R7

            ENDP


; ========================================================================== ;
; Data                                                                       ;
; ========================================================================== ;

; -------------------------------------------------------------------------- ;
; Periods of the 84 defined notes                                            ;
; (from C-1 to B-7)                                                          ;
; -------------------------------------------------------------------------- ;

notes:      DECLE       $0D5C, $0C9D, $0BE7, $0B3C, $0A9B, $0A02, $0973, $08EB
            DECLE       $086B, $07F2, $0780, $0714, $06AE, $064E, $05F4, $059E
            DECLE       $054D, $0501, $04B9, $0475, $0435, $03F9, $03C0, $038A
            DECLE       $0357, $0327, $02FA, $02CF, $02A7, $0281, $025D, $023B
            DECLE       $021B, $01FC, $01E0, $01C5, $01AC, $0194, $017D, $0168
            DECLE       $0153, $0140, $012E, $011D, $010D, $00FE, $00F0, $00E2
            DECLE       $00D6, $00CA, $00BE, $00B4, $00AA, $00A0, $0097, $008F
            DECLE       $0087, $007F, $0078, $0071, $006B, $0065, $005F, $005A
            DECLE       $0055, $0050, $004C, $0047, $0043, $0040, $003C, $0039
;            DECLE       $0035, $0032, $0030, $002D, $002A, $0028, $0026, $0024
;            DECLE       $0022, $0020, $001E, $001C

; -------------------------------------------------------------------------- ;
; Vibrato amplitude for each note above                                      ;
; (30% of an half-tone)                                                      ;
; -------------------------------------------------------------------------- ;

            DECLE       $003B, $0038, $0035, $0032, $002F, $002C, $002A, $0028
            DECLE       $0025, $0023, $0021, $001F, $001E, $001C, $001A, $0019
            DECLE       $0018, $0016, $0015, $0014, $0013, $0012, $0011, $0010
            DECLE       $000F, $000E, $000D, $000C, $000C, $000B, $000A, $000A
            DECLE       $0009, $0009, $0008, $0008, $0007, $0007, $0007, $0006
            DECLE       $0006, $0006, $0005, $0005, $0005, $0004, $0004, $0004
            DECLE       $0004, $0003, $0003, $0003, $0003, $0003, $0003, $0002
            DECLE       $0002, $0002, $0002, $0002, $0002, $0002, $0002, $0002
            DECLE       $0001, $0001, $0001, $0001, $0001, $0001, $0001, $0001
;            DECLE       $0001, $0001, $0001, $0001, $0001, $0001, $0001, $0001
;            DECLE       $0001, $0001, $0001, $0000
